<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12">
            <h3 class="ml-5"><?php echo e(__('messages.INVENTAIRE PAR MAGASIN')); ?></h3>
            <div class="row">
                <div class="col-12 col-sm-6 col-md-7 mb-3">
                    <div class="d-flex">
                    <h5 class="ml-5"><?php echo e(__('messages.NOUVEL INVENTAIRE')); ?></h5>
                    </div>
                </div>
                <div class="col-12 col-sm-6 col-md-5 mb-3">
                    <div class="d-flex">
                        <a href="<?php echo e(route('inv.histo')); ?>" class="btn btn-success btn-block text-truncate"><i class="fa fa-globe"></i> <?php echo e(__('messages.Historiques des inventaires')); ?></a>
                    </div>
                </div>
            </div>
        </div>

        <br>

        <div class="info-box mb-1 flex-column">
            <div class="d-flex align-items-center">
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date debut </label>
                    <input type="date" name="from_date" id="from_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date debut </label>
                    <input type="date" name="to_date" id="to_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-3" style="margin-top: 30px">
                    <select name="magasin_id" id="magasin_id" class="form-control" onchange="actualiser()">
                        <?php $__currentLoopData = $magasins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$magasin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo $magasin; ?>"> <?php echo $magasin; ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-12 col-md-3" style="margin-top: 30px">
                    <button type="button" name="filter" id="filter" class="btn btn-danger inline"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="imprimer" id="imprimer" class="btn btn-primary inline"><?php echo e(__('messages.Imprimer')); ?></button>
                </div>
            </div>

            <form id="inventaire">
                <?php echo csrf_field(); ?>
                <div class="d-flex align-items-center mt-3 additional-fields" style="min-height: 40px; margin-bottom: 10px; flex-direction: row;">
                <!-- Champs date et bouton Enregistrer -->
                    <div class="col-12 col-md-3" id="additionalDate" style="display: none;">
                        <input type="date" name="date_inventaire" id="date_inventaire" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" />
                    </div>
                    <div class="col-12 col-md-3" id="additionalPrompt" style="display: none;">
                        <input type="text" name="promptitude" id="promptitude" class="form-control" placeholder="promptitude" required/>
                    </div>
                    <div class="col-12 col-md-3" id="additionalButton" style="display: none;">
                        <button type="submit" name="enregistrer" id="enregistrer" class="btn btn-success inline"><?php echo e(__('messages.Enregistrer')); ?></button>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="pdt_mag">
                        <thead>
                        <tr class="cart_menu" style="font-size: 14px">
                            <td class="price"><?php echo e(__('messages.Produit')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte initiale')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte recue')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte totale')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte sortie')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte theorique dispo')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte restante')); ?></td>
                            <td class="price"><?php echo e(__('messages.Ecart a l\'inventaire')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte empruntee')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte pretee')); ?></td>
                            <td class="price"><?php echo e(__('messages.Perte du mois')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte avariee/cassee')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte perimee')); ?></td>
                            <td class="price"><?php echo e(__('messages.Autres')); ?></td>
                            <td class="price"><?php echo e(__('messages.Commentaires')); ?></td>
                            <td class="total"><?php echo e(__('messages.Editer')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

        <!-- Exemple de modal amélioré -->
        <div id="editModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title text-center" id="productName">Editer l'inventaire du produit</h4>
                        <button type="button" class="close" data-dismiss="modal" style="color: red;">&times;</button>
                    </div>
                    <span class="form_result" id="form_result"></span>
                    <form id="inventaireProduit">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <!-- Contenu du modal -->
                                <div class="col-md-8 offset-md-2">
                                    <label for="libelle" class="font-weight-normal" id="libelle"> </label>
                                    <input type="hidden" id="produit_inventaire_id" name="produit_inventaire_id">
                                </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label for="qte_comptee" class="font-weight-normal">Qte compte :</label>
                                    <input type="number" id="qte_comptee" class="form-control" name="qte_comptee" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="ecart_inventaire" class="font-weight-normal">Ecart a l'inventaire :</label>
                                    <input type="number" id="ecart_inventaire" class="form-control" name="ecart_inventaire" readonly>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label for="qte_emprunt" class="font-weight-normal">Qte empruntee :</label>
                                    <input type="number" id="qte_emprunt" class="form-control" name="qte_emprunt" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="qte_pret" class="font-weight-normal">Qte pretee :</label>
                                    <input type="number" id="qte_pret" class="form-control" name="qte_pret" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label for="qte_perdue" class="font-weight-normal">Perte du mois :</label>
                                    <input type="number" id="qte_perdue" class="form-control" name="qte_perdue" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="qte_avariee" class="font-weight-normal">Qte avariee/cassee :</label>
                                    <input type="number" id="qte_avariee" class="form-control" name="qte_avariee" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label for="qte_perimee" class="font-weight-normal">Qte perimee :</label>
                                    <input type="number" id="qte_perimee" class="form-control" name="qte_perimee" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="autres_qte" class="font-weight-normal">Autres perte :</label>
                                    <input type="number" id="autres_qte" class="form-control" name="autres_qte" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-10 offset-md-1">
                                    <label for="commentaires" class="font-weight-normal">Commentaires :</label>
                                    <input type="text" id="commentaires" class="form-control" name="commentaires">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-center mt-3">
                                    <button type="submit" class="btn btn-success" id="saveChangesBtn">Enregistrer</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>

        <!-- Modal pour afficher les réponses -->
        <div class="modal fade" id="responseModal" tabindex="-1" role="dialog" aria-labelledby="responseModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="responseModalLabel">Réponse de l'opération</h5>
                        <!-- Supprimez le bouton de fermeture par défaut -->
                    </div>
                    <div class="modal-body">
                        <p id="responseMessage"></p>
                    </div>
                    <div class="modal-footer">
                        <!-- Utilisez une classe pour rendre le bouton de fermeture en rouge -->
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Fermer</button>
                    </div>
                </div>
            </div>
        </div>


    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        function magasin() {
            $.ajax({
                url:"inv.magasins",
                dataType:"json",
                success:function(data)
                {
                    $('#magasin_id').empty();
                    $('#magasin_id').append('<option id="0"  value="0">- <?php echo e(__('messages.Choisir un magasin')); ?> -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#magasin_id').append('<option id=' + data[i].magasin_id + ' value=' + data[i].magasin_id + '>'+ data[i].libelle +'</option>');
                    }
                    $('#magasin_id').change();
                }
            })
        }

        function actualiser() {
            magasin_id = document.getElementById("magasin_id").value;
        }

        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            magasin()

            load_data();

            function load_data(from_date = '', to_date = '', magasin_id=0) {
                pdt_magDataTable = $('#pdt_mag').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("inv.invmagasin")); ?>',
                        data:{from_date:from_date, to_date:to_date, magasin_id:magasin_id}
                    },
                    columns: [
                        {
                            data:'libelle',
                            name:'libelle'
                        },
                        {
                            data:'qte_debut',
                            name:'qte_debut'
                        },
                        {
                            data:'qte_recue',
                            name:'qte_recue'
                        },
                        {
                            data:'qte_totale',
                            name:'qte_totale'
                        },
                        {
                            data:'qte_sortie',
                            name:'qte_sortie'
                        },
                        {
                            data:'qte_theorique',
                            name:'qte_theorique'
                        },
                        {
                            data:'qte_comptee',
                            name:'qte_comptee',
                        },
                        {
                            data:'ecart_inventaire',
                            name:'ecart_inventaire'
                        },
                        {
                            data:'qte_emprunt',
                            name:'qte_emprunt'
                        },
                        {
                            data:'qte_pret',
                            name:'qte_pret'
                        },
                        {
                            data:'qte_perdue',
                            name:'qte_perdue'
                        },
                        {
                            data:'qte_avariee',
                            name:'qte_avariee'
                        },
                        {
                            data:'qte_perimee',
                            name:'qte_perimee'
                        },
                        {
                            data:'autres_qte',
                            name:'autres_qte'
                        },
                        {
                            data:'commentaires',
                            name:'commentaires'
                        },
                        {
                            data:'produit_inventaire_id',
                            name:'produit_inventaire_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.produit_inventaire_id+"' class='btn btn-success edit'><i class='fa fa-edit'></i></a>"}
                        }

                    ]
                });
            }

            function showModal(responseMessage) {
                $('#responseMessage').text(responseMessage);
                $('#responseModal').modal('show');
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                var magasin_id = $('#magasin_id').val();
                if(from_date != '' && to_date != '')
                {
                    $('#pdt_mag').DataTable().destroy();
                    load_data(from_date, to_date,magasin_id);
                }
                else
                {
                    alert('<?php echo e(__('messages.Selectionner la periode')); ?>');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#inventaires').DataTable().destroy();
                load_data();
            });

            $('#imprimer').click(function(){
                var debut = document.getElementById('from_date').value;
                var fin = document.getElementById('to_date').value;
                var magasin_id = document.getElementById('magasin_id').value;

                var newWin = window.open();
                var the_url = "inv.print_invmagasin/"+debut+"/"+fin+"/"+magasin_id;
                $.ajax({
                    type: "GET", url: the_url, data: {},
                    success: function(data){
                        newWin.document.write(data);;
                    }
                    ,error: function() {
                    }
                });
            });

            $(document).on('click', '.edit', function() {
                var id = this.id;
                $.ajax({
                    url: "inv.getinvproduit/" + id,
                    dataType: "json",
                    success: function(data) {
                        $('#produit_inventaire_id').val(data.produit_inventaire_id);
                        $('#libelle').html('Produit: ' + data.libelle);
                        $('#qte_comptee').val(data.qte_comptee);
                        $('#ecart_inventaire').val(data.qte_theorique - data.qte_comptee);
                        $('#qte_emprunt').val(data.qte_emprunt);
                        $('#qte_pret').val(data.qte_pret);
                        $('#qte_perdue').val(data.qte_perdue);
                        $('#qte_avariee').val(data.qte_avariee);
                        $('#qte_perimee').val(data.qte_perimee);
                        $('#autres_qte').val(data.autres_qte);
                        $('#commentaires').val(data.commentaires);

                        // Ajouter un gestionnaire d'événements pour recalculer l'écart_inventaire lorsqu'il y a un changement dans qte_comptee
                        $('#qte_comptee').on('input', function() {
                            var nouvelleValeur = parseInt($(this).val());
                            var ecartInventaire = data.qte_theorique - nouvelleValeur;
                            $('#ecart_inventaire').val(ecartInventaire);
                        });
                    }
                });

                $('#form_result').html('');
                $('#editModal').modal('show');
            });

            $('#inventaireProduit').on('submit', function(event){
                event.preventDefault();
                $.ajax({
                    url:"<?php echo e(route('inv.updateinvproduit')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';

                            $('#inventaireProduit')[0].reset();
                            $('#editModal').modal('hide');

                            var rowIndex = pdt_magDataTable.rows().indexes().filter(function (value, index) {
                                return pdt_magDataTable.row(value).data().produit_inventaire_id == data.produit_inventaire_id;
                            });

                            // Mettre à jour la ligne si elle existe
                            if (rowIndex.length > 0) {
                                pdt_magDataTable.row(rowIndex[0]).data(data.updatedData);
                            }
                        }
                        $('#form_result').html(html);
                    }
                })
            });

            function isDataTableEmpty() {
                return pdt_magDataTable.rows().count() === 0;
            }

            function toggleAdditionalFieldsVisibility() {
                if (isDataTableEmpty()) {
                    $('#additionalDate').hide();
                    $('#additionalPrompt').hide();
                    $('#additionalButton').hide();
                } else {
                    $('#additionalDate').show();
                    $('#additionalPrompt').show();
                    $('#additionalButton').show();
                }
            }

            toggleAdditionalFieldsVisibility();

            pdt_magDataTable.on('draw', function () {
                toggleAdditionalFieldsVisibility();
            });

            $('#inventaire').on('submit', function(event){
                event.preventDefault();
                var magasin_id = $('#magasin_id').val();
                var date_debut = $('#from_date').val();
                var date_fin = $('#to_date').val();

                var formData = new FormData(this);
                formData.append('magasin_id', magasin_id);
                formData.append('date_debut', date_debut);
                formData.append('date_fin', date_fin);

                $.ajax({
                    url: "<?php echo e(route('inv.enreg_inventaire')); ?>",
                    method: "POST",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData: false,
                    dataType: "json",
                    success: function(data) {
                        var html = '';
                        if(data.errors) {
                            showModal(data.errors);
                        }
                        if(data.error) {
                            showModal(data.error);
                        }
                        if(data.success) {
                            showModal(data.success);
                            pdt_magDataTable.clear().destroy();
                            $('#from_date').val('');
                            $('#to_date').val('');
                            $('#inventaire')[0].reset();
                            toggleAdditionalFieldsVisibility();
                            magasin()
                            load_data();
                        }
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/inventaire/invmagasin.blade.php ENDPATH**/ ?>